<?php
    /**
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    *
    * File che consente di gestire le operazioni con le immagini
    */

    include "../include/costanti.php";
    include "../include/util.php";
    include "../gUtil/DbManager.php";
    include "../gUtil/GestoreUpload.php";
    include "../gUtil/ElaboratoreImmagini.php";
    include "../gUtil/ControlloreStringhe.php";
    include "../classi/Immagine.php";
    
    session_start();
    controlloAccessoAdmin();
    
    //i dati del database sono definiti nel file costanti.php
    $geecomDb = new DbManager($costantiDatabase);
    $impostazioni = recuperaImpostazioni($geecomDb);

    $operazione = filter_input(INPUT_POST,"operazione",FILTER_SANITIZE_ADD_SLASHES);    
    $immagine = new Immagine($geecomDb, filter_input(INPUT_POST, "id"));
    
    switch ($operazione) {
        case 'crea':
            $immagine->setIdContenuto(filter_input(INPUT_POST,"idContenuto",FILTER_SANITIZE_NUMBER_INT));
            $immagine->setTipoImmagine(filter_input(INPUT_POST,"tipoImmagine",FILTER_SANITIZE_ADD_SLASHES));
            $immagine->setPercorso($percorso);
            $immagine->setDescrizione(ilter_input(INPUT_POST,"descrizione",FILTER_SANITIZE_ADD_SLASHES));
            $immagine->setPosizione(filter_input(INPUT_POST,"posizione",FILTER_SANITIZE_NUMBER_INT));
            $immagine->crea();
            echo "ok";
            break;
        case 'modifica':
            $immagine->setIdContenuto(filter_input(INPUT_POST,"idContenuto",FILTER_SANITIZE_NUMBER_INT));
            $immagine->setTipoImmagine(filter_input(INPUT_POST,"tipoImmagine",FILTER_SANITIZE_ADD_SLASHES));
            $immagine->setPercorso($percorso);
            $immagine->setDescrizione(ilter_input(INPUT_POST,"descrizione",FILTER_SANITIZE_ADD_SLASHES));
            $immagine->setPosizione(filter_input(INPUT_POST,"posizione",FILTER_SANITIZE_NUMBER_INT));
            
            $immagine->modifica();
            echo "ok";
            break;
        case 'modificaDidascalia':
            $immagine->caricaDatiDalDatabase();
            $immagine->setDescrizione(filter_input(INPUT_POST,"descrizione",FILTER_SANITIZE_ADD_SLASHES));
            $immagine->modifica();
            echo "ok";
            break;
        case 'elimina':
            $immagine->elimina();
            $immagine->eliminaFile();
            break;
        case 'eliminaSoloOccorrenza':
            $immagine->elimina();
            echo "ok";
            break;
        case 'caricaImmaginiCartellaAltro':
            if($_FILES['file']['name']!="") {
                $tipiFileAmmessi = array("image/png","image/jpeg","image/gif");
                $gestoreUpload = new GestoreUpload("file", $tipiFileAmmessi, 8, "../immagini/altro", 0, "");
                $esitoUpload  = $gestoreUpload->salvaFile();
                if($esitoUpload["percorso"]=="") {
                    echo "Errore: tipo di file non ammesso";
                    exit();
                }
                else {
                    $percorsoFoto = str_replace("../","",$esitoUpload["percorso"]);
                    echo "ok";
                }

                // se nelle impostazioni è spuintata la voce  "ottimizza immagini caricate" viene modificata
                if($impostazioni["ottimizzaImmaginiCaricate"]=="si") {
                    $elaboratoreImmagini = new ElaboratoreImmagini($esitoUpload["percorso"]);
                    if($elaboratoreImmagini->getAltezza()>$impostazioni["altezzaImmagine"]) {
                        $elaboratoreImmagini->modificaInScala("altezza", $impostazioni["altezzaImmagine"], $esitoUpload["percorso"]);
                    }
                }
            }
            break;
        case 'eliminaFileImmagine': // questa azione viene usata quando si eliminano immagini dall'area risorse
            $percorso = filter_input(INPUT_POST,"percorso",FILTER_SANITIZE_ADD_SLASHES);
            $immagine->eliminaFile($percorso);
            echo "ok";
            break;
    }